//
//  MCReportPreviewReport.h
//  MCReporting
//
//  Created by Alykhan Jetha on 13/05/08.
//  Copyright 2008 __MyCompanyName__. All rights reserved.
//

#import <MCApplication/MCNibLoadingView.h>

@class MCReportWrapper;
@class MCReportCenteringScrollView;
@class MCReportWebView;
@class MCGenericBorderView;
@class MCReportGenerator;
@class PDFView;

@interface MCReportPreviewReport : MCNibLoadingView {
	NSUInteger currentPageCount;

	IBOutlet NSTabView *tabView;
	IBOutlet NSView *buttonsBox;

	IBOutlet NSProgressIndicator *wheelIndicator;
	IBOutlet NSTextField *progressField;
	
	IBOutlet MCReportCenteringScrollView *userInputScrollView;
	IBOutlet PDFView *pdfView;
	IBOutlet NSScrollView *simulationScrollView;


	IBOutlet NSButton *backButton;
	IBOutlet NSButton *generateThenPrintButton;
	IBOutlet NSTextField *startTabMessageField;
	
	IBOutlet MCReportWebView *webview;
	IBOutlet NSBox *webViewControls;
	
	MCReportWrapper *currentReport;
	NSString *generatedReportPath;
	
	BOOL inSimulationMode;
	IBOutlet NSMenu *simulationCanvasMenu;

}

@property (assign) BOOL inSimulationMode;

- (MCReportWrapper *)currentReport;
- (void)setCurrentReport:(MCReportWrapper *)aCurrentReport;

- (void)ensureStartViewInPlace;
- (void)ensureCriteriaViewInPlace;
- (void)ensureProgressViewInPlace;
- (void)ensurePreviewViewInPlace;
- (void)ensureSimulationViewInPlace;
- (void)ensureWebViewInPlace;

// subclassers can draw a different background, otherwise white is drawn.
- (void)drawBackgroundInRect:(NSRect)rect;

- (IBAction)generateThenPrint:(id)sender;
- (IBAction)backToCriteria:(id)sender;
- (IBAction)reload:(id)sender;

- (IBAction)toggleDebugLines:(id)sender;


- (void)generateReport:(MCReportWrapper *)aReport;

- (NSDocument *)_repDocument;
- (void)putView:(NSView *)aView intoScrollView:(NSScrollView *)aScroll backgroundColor:(NSColor *)aColor;

@end
